//Compile with /J
#pragma warning(disable:4668) //undefined symbol replaced by 0 for preprocessor #if directive
#pragma warning(disable:4820) //padding bytes
#include "system.h"
#include <malloc.h>
#include <cstring>
#include "ATmem.h"
#include "ATstring.h"
#include "Paths.h"
#include "Messages.h"
#include <cmath>
#include <float.h>
#pragma warning(disable:4217 4702) //Los ficheros de cabecera de C++ estn llenos de errores
#include <iostream>
#include <fstream>
#pragma warning(disable:4245) //assignment of negative constant to unsigned variable
#pragma warning(disable:4701) //la variable local 'tal' se puede utilizar sin haberse inicializado
#pragma warning(default:4702)

#include "Aerotri_defs.h"
#include "matematicas.h"
#include "bucles_y_matrices.h"
#include "Clases.h"
#include "Estimadores.h"
#include "Rotacion.h"
#include "Clases_inercial.h"
using namespace Inercial;
#include "Funciones.h"
#include "trans_Hel2D.h"
#include "Geodesica.h"
#include "distribucion_residuos.h"
#include "gravimetria.h"
#include "lecturaf.h" //lib lecturaf.lib
#include "Lectura_inercial.h"
/* Globales */
struct {
	u8int idioma;
	u8int idioma_f;
} gb;
/* End globals */
#include "Escritura de Ficheros.h"

#define Std_return if(log_file!=0){fprintf(log_file,"\nPrograma 'inercial' terminado por: %s\n",mensaje); fflush(log_file);} return nret
#define Abort_return if(log_file!=0){fprintf(log_file,"\nPrograma 'inercial' abortado por el usuario\n"); fflush(log_file);} return nret

//The entry point. Does nothing
DEFAULT_ENTRY

int __stdcall maininercial(Handler hwnd_main, FILE* log_file,u16int log_level,
									char* ficherogps,u8int gpm, s8int extragps, char* ficheroimu,u8int imm, char* ficheropau,u8int pam,bint signoimu,
									float offsetX,float offsetY,float offsetZ, ModeloErrores errores,
									s8int uni, char* mensaje, u8int idioma=0){
 if(idioma>Id_It) idioma=0;
 if(!(log_level & 1)) log_level=0;
 if(log_file!=0) fprintf(log_file,"\n***Comienzo del programa 'ajinercial', v. 0.1***\n");
 int nret=0;

 double ccpi=1;
 if(uni==1) ccpi=63.6619772368;
 if(uni==2) ccpi=57.2957795131;
 char* ext, *extapr;
 char extaux[4];
 u16int lof;
 lof=strlen(ficherogps);
 ext=ficherogps+lof+extragps-7;
 s8int decf, decp;
 s8int *pdecf, *pdecp;

 uint i;
 vector<PuntopreGPS> pregpss;
 vector<PuntoIMU> preimus;
 vector <Pausa> _pausas;
 PuntoXYZ<double> P,Q;
 PuntoXYZ<float> Pf,Qf;
 PuntopreGPS* punpregps;
 PuntoIMU* punpimu;
 uint ngps, nimu, npau;
 double TIME0;
 double t, cosk, sink;


 if(log_file!=0 && log_level!=0) fprintf(log_file,"Leyendo el fichero de datos GPS '%s'\n",ficherogps);
 nret=lee_ficheropregps(ficherogps,gpm,pregpss,ngps);
  *(ext-1)='.'; *ext='p'; *(ext+1)='r'; *(ext+2)='e'; *(ext+3)='.';
 if(gpm>1 && !nret){
	 *(ext+4)='g'; *(ext+5)='p'; *(ext+6)='s';
	 nret=escribe_pregps(ficherogps,pregpss._Myfirst,ngps);
	 if(nret<0) strcpy(mensaje,"XXgpm");
 }
 if(nret){
	 //CierraLlave(&HaspHl);
	 if(nret<0){Abort_return;}
	 else{nret=2; Std_return;}
 }

 if(log_file!=0 && log_level!=0) fprintf(log_file,"Leyendo el fichero de datos IMU '%s'\n",ficheroimu);
 nret=lee_ficheropreimu(ficheroimu,imm,preimus,nimu);

 if(pam!=255){
	 if(log_file!=0 && log_level!=0) fprintf(log_file,"Leyendo el fichero de pausas '%s'\n",ficheroimu);
	 nret=lee_ficheropausas(ficheropau,_pausas,npau);
 }else{npau=0;}

 TIME0=pregpss._Myfirst->Pt.t;
 punpregps=pregpss._Myfirst;
 for(i=ngps;i--;punpregps++){
	t=punpregps->Pt.t-TIME0;
	t*=ROT_TIERRA;
	cosk=cos(t);	sink=sin(t);
	t= punpregps->Pt.X*cosk+punpregps->Pt.Y*sink;
	punpregps->Pt.Y= -punpregps->Pt.X*cosk+punpregps->Pt.Y*cosk;
	punpregps->Pt.X=t;
 }

 PPausa* pausas= new PPausa[npau];
 for(i=0;i<npau;i++){
	 pausas[i].ti=_pausas[i].ti;
	 pausas[i].tf=_pausas[i].tf;
 }
 _pausas.clear();

 PuntoXYZ<double>* posiciones= new PuntoXYZ<double>[ngps];	//No todas sern parmetro;
 PuntoXYZ<float> Aceldespl, Girodespl;
 double Acelescala;

 return 0;
}